# TCP/IP 흐름제어 & 혼잡제어

네트워크 통신과정 도중에는 네트워크 혼잡성 및 수신 측의 overload 등의 사유로 데이터가 손실되거나, 전달 순서가 바뀌는 등의 문제가 발생할 수 있다. </br>
이런 문제를 해결하고 통신의 신뢰성을 보장하기 위해 TCP/IP에서 사용하는 것이 **흐름 제어와 혼잡 제어**이다.

> TCP 버퍼는 전송 및 수신 전 TCP 세그먼트는 보관하는 곳이다. </br>
> 송신 측은 버퍼에 TCP 세그먼트를 보관한 후 순차적으로 전송하고, 수신 측은 도착한 TCP 세그먼트를 애플리케이션이 읽을 때까지 버퍼에 보관한다. </br>

</br>

- 흐름제어 
  - **송신측**과 **수신측**의 데이터 처리 속도 차이를 해결하기 위한 기법
  - 즉, 송신 측이 패킷을 지나치게 많이 받지 않도록 조절하는 것이다.
  - 수신측이 송신측에게 현재 자신의 상태를 피드백 함으로서 흐름제어가 이루어진다.
- 혼잡 제어
  - 네트워크가 불안정하여 데이터가 원활히 통신이 안되면 제어를 통해 재전송을 하게 되는데, 재전송 작업이 반복되면 네트워크가 붕괴될 수도 있다.
  - 따라서 네트워크 혼잡 상태가 감지되면 송신 측의 전송 데이터 크기를 조절하여 전송량을 조절한다. 
  - 즉, **송신측**의 데이터 전달과 **네트워크**의 데이터 처리 속도 차이를 해결하기 위한 제어 기법이다.

</br>

## 흐름제어 (Flow Control)
- 수신자가 처리 할 수 있는 데어터 속도가 다르기 때문에, 송신 측은 수신 측의 데이터 처리 속도를 파악하고 얼마나 빠르게 어느 정도의 데이터를 전송할 지 제어하는 것이다.
- 수신 측의 저장 용량을 초과한 이후에 도착하는 데이터들은 손실될 수 있고, 만약 손실이 발생하면 불필요한 응답과 동일한 데이터 전송이 발생한다.

</br>

## 흐름제어의 해결 방식
### **1. Stop and Wait** 

- 매번 전송한 패킷에 대해 확인 응답(ACK)을 받아야만 다음 패킷을 전송하는 방법이다.
- 패킷을 하나씩 보내고 확인해야 하기 때문에 비효율적이다.

<img  width="280" src="https://img1.daumcdn.net/thumb/R1280x0/?scode=mtistory2&fname=https%3A%2F%2Fblog.kakaocdn.net%2Fdn%2FU95D6%2FbtrgCEg591n%2FtXKNCWUoAyKfpWZ5IaRKI0%2Fimg.png">

</br>

### **2. Sliding Window**

- 수신 측이 설정한 *윈도우 크기 만큼 송신 측에서 확인 응답(ACK)없이 패킷을 전송하여 데이터의 흐름을 동적으로 조절하는 방법이다.
- 수신 측이 한 번에 처리할 수 있는 데이터의 양 즉 Receive Window size를 3 way handshake할 때 송신 측에 전달한다.
- 통신 과정 중에도 네트워크 혼잡 등의 조건을 통해 윈도우 크기는 유동적으로 설정된다.

\**Window : 받을 수 있는 최대 패킷의 수* 
\**TCP/IP를 사용하는 모든 호스트들은 송신, 수신을 위한 2개의 Window를 가지고 있다.* </br>

</br>
 
#### **동작 방식**
- 먼저 윈도우의 크기 만큼에 포함되는 모든 패킷을 전송한다.
- 수신 측은 확인 응답을 보내면서 남은 윈도우의 크기도 함께 보내준다.
- 해당 패킷들의 전달이 확인되면 송신 측은 빈 공간만큼 윈도우를 옆으로 옮긴 후, 다음 패킷들을 전송한다.
  
<img  width="600" src="https://user-images.githubusercontent.com/102718303/214805020-36be43ec-a5ae-4aa4-8485-393fe599d307.png">

</br>

> 예시에서 최초로 수신자는 윈도우 사이즈를 7로 정한다. </br>
> 송신자는 수신자의 확인 응답을 받기 전까지 데이터를 모두 전송한다. </br>
> 수신자가 확인 응답을 보내면, 윈도우 사이즈를 충족할 수 있도록 옆으로 옮긴다. </br>
> 데이터를 다 받을 때까지 위의 과정을 반복한다. </br>
 
</br>

## 혼잡 제어 (Congestion Control)
- 전송되는 패킷의 양이 라우터가 처리할 수 있는 양을 초과하면 **오버플로우나 데이터 손실**이 발생한다.
- 송신 측은 처리못한 데이터를 손실로 간주해 계속해서 재전송하게 되고, *혼잡이 가중된다.
- 혼잡 제어는 송수신 측 사이의 패킷 수를 제어하는 기능이고, 네크워크의 오버플로우를 방지한다.
- TCP에는 Tahoe, Reno, New Reno, Cubic, Elastic-TCP ..등 다양한 혼잡 제어 기법이 존재한다.

\**혼잡 : 네트워크 내에 패킷의 수가 과도하게 증가하는 현상*

</br>

## 혼잡 제어의 해결 방식

### 1. AIMD (Additive Increse/Multicative Decrease)
- AIMD 방식은 처음에 패킷을 하나씩 보내고 문제없이 도착하면 윈도우의 크기를 1씩 증가시킨다.
- 만약 전송에 실패하거나 일정 시간이 넘으면 윈도우 크기를 반으로 줄인다.
- 여러 호스트가 한 네트워크를 공유하고 있으면 나중에 진입하는 쪽이 처음에는 불리하지만, 시간이 흐르면 평형상태로 수렴하게 되는 특징이 있다.
- 단점은 윈도우의 크기가 조금씩 늘어나기 때문에 정상 속도로 통신하기까지 시간이 오래 걸린다.

<img width="480" src="https://user-images.githubusercontent.com/102718303/214809474-164fb47a-a188-4be9-92be-b0624724cbbb.png">

</br>

### 2. Slow Start (느린 시작)
- Slow Start는 AIMD의 단점을 보완하여 윈도우의 크기를 `1, 2, 4, 8,,,`로 지수적으로 증가시킨다.
- 만약 혼잡이 감지되면 윈도우의 크기를 1로 줄인다.
- 처음에는 네트워크 수용량을 예상할 수 있는 정보가 없지만, 한 번 혼잡 현상이 발생한 후에는 네트워크의 수용량을 어느 정도 예상할 수 있다.
- 그래서 혼잡 현상이 발생하는 윈도우 크기의 절반가지는 지수 함수 꼴로 윈도우 크기를 증가시키고 그 이후에는 완만하게 1씩 증가시킨다.

<img width="550" src="https://img1.daumcdn.net/thumb/R1280x0/?scode=mtistory2&fname=https%3A%2F%2Fblog.kakaocdn.net%2Fdn%2Fbq6URf%2FbtrMzDJ7J9m%2FToERAMyMqvR4F1Ii3WkiT0%2Fimg.png">

</br>

### 3. 빠른 재전송
- 패킷을 받는 수신 측은 패킷으로 분할된 내용들이 순서대로 도착하지 않는 경우가 생길 수 있다.
- 따라서 수신 측은 순서대로 잘 도착한 패킷의 다음 순번을 확인 응답과 함께 보낸다.
- 또한 이러한 확인 응답을 중복으로 3개를 받으면 재전송한다.
- 송신 측은 자신이 설정한 \*타임 아웃시간과 무관하게 바로 패킷을 재전송 할 수 있기 때문에 재전송률을 빠르게 유지할 수 있다.

\**타임 아웃 : 여러 요인으로 인해 송신측의 데이터가 유실되거나, 확인 응답이 유실되어 시간 초과되는 경우*

<img width="540" src="https://img1.daumcdn.net/thumb/R1280x0/?scode=mtistory2&fname=https%3A%2F%2Fblog.kakaocdn.net%2Fdn%2FbloQMX%2FbtrMwYIIB3I%2FFRtyhE6IQKkuLfbK5IABjk%2Fimg.png">
</br>

### 4. 빠른 회복
- 빠른 회복은 혼잡 상태가 감지되면 윈도우 크기를 1로 줄이지 않고 반으로 줄인 뒤 1씩 증가시킨다.
- 증가는 **Slow Start 방식**으로 하지만 한번 혼잡을 겪으면 **AIMD 방식**으로 동작한다. 

</br>

----
## Referance
- https://steady-coding.tistory.com/507
- https://gyoogle.dev/blog/computer-science/network/%ED%9D%90%EB%A6%84%EC%A0%9C%EC%96%B4%20&%20%ED%98%BC%EC%9E%A1%EC%A0%9C%EC%96%B4.html
- https://yeoneeds.tistory.com/25
  
  
  
  
